import { Component, OnInit, Input } from '@angular/core';
import { NgRedux, select } from 'ng2-redux';
import { IAppState } from '../../../../store';
import { MvpServices } from '../../../../services/mvp-services';

@Component({
  selector: 'app-mvp-add-super-classes',
  templateUrl: './mvp-add-super-classes.component.html',
  styleUrls: ['./mvp-add-super-classes.component.scss']
})
export class MvpAddSuperClassesComponent implements OnInit {
  @Input() tindex;
  @Input() tabType;
  @Input() mvpObject;
  selectedBookmark: any;
  onHoverSubmit: boolean;
  @select(['system', 'focusedElement']) focusedElement;
  constructor(
    private ngRedux: NgRedux<IAppState>,
    public mvpServices: MvpServices) { }

  ngOnInit() {
  }

  anyBookmarksExists() {
    return this.mvpServices.getMvpBookmarkedConceptList() != null && this.mvpServices.getMvpBookmarkedConceptList().length > 0; 
  }

  onSubmit() {
    //We need a way to throw an error message if conceptUri Doesn't exist?
    if (this.selectedBookmark != null && this.selectedBookmark != "0" &&
      this.selectedBookmark.conceptUri != null &&
      this.selectedBookmark.conceptUri.length > 0) {
      this.mvpObject.object = this.selectedBookmark.conceptUri;
      this.mvpServices.addMvpConcept(this.mvpObject, this.tabType);
    }
  }

}
